<div class="container mt-4">
    <!-- Search Input -->

    <!-- Table -->
    <div class="card card-flush">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">عرض قائمة الشعب الدراسية</h3>
            <button type="button" class="btn btn-success" wire:click="openModal">
                <i class="fa fa-plus"></i> اضافة شعبة دراسية
            </button>
        </div>

        <div class="card-body">
            <div class="mb-4">
                <input type="text"
                       wire:model.live.debounce.250ms="search"
                       class="form-control form-control-solid"
                       placeholder="Search by name...">
            </div>

            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr>
                    <th>
                        {{ __('label.name') }}
                        @if($sortField === 'name')
                            <i class="fa fa-sort-{{ $sortDirection }}"></i>
                        @endif
                    </th>
                    <th>مرحلة الدراسية</th>
                    <th>السعة الافتراضية</th>
                    <th>السعة الحالية</th>
                    <th>الحالة</th>
                    <th>العمليات</th> <!-- Added a header for the actions column -->
                </tr>
                </thead>
                <tbody>
                @foreach($classSections as $value)
                    <tr>
                        <td>{{ $value->name }}</td>
                        <td>{{ $value->classRooms?->name }}</td>
                        <td>{{ $value->capacity }}</td>
                        <td>{{ $value->current_capacity }}</td>
                        <td>{!! $value->getStatus() !!}</td>
                        <td>

                            <button wire:click="openModal({{ $value->id }})" class="btn btn-primary btn-sm">
                                <i class="fa fa-edit"></i> تعديل
                            </button>
                            <button wire:click="confirmDelete({{ $value->id }})" class="btn btn-danger btn-sm">
                                <i class="fa fa-trash"></i> حذف
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <!-- Pagination Links -->
            <div class="mt-4">
                {{ $classSections->links('vendor.livewire.bootstrap') }}
            </div>
        </div>
    </div>

    <!-- Modal for Edit/Create Grade -->
    @if($isModalOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-xl" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ $classSectionId ? 'تعديل بيانات الشعبة الدراسية' : 'اضافة شعبة دراسية' }}</h5>
                        <button type="button" class="btn-close" wire:click="closeModal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">
                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="name" class="form-label">
                                        الاسم <span class="required"></span>
                                    </label>
                                    <input type="text" id="name" wire:model="name" class="form-control form-control-solid">
                                    @error('name') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <label for="capacity" class="form-label">
                                        سعة الشعبة <span class="required"></span>
                                    </label>
                                    <input type="number" min="1" id="capacity" wire:model="capacity" class="form-control form-control-solid">
                                    @error('capacity') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>

                            <div class="col-sm-12 col-lg-3">
                                <label for="class_room_id" class="form-label">
                                    المرحلة الدرسية <span class="required"></span>
                                </label>
                                <select name="class_room_id"
                                        wire:model="class_room_id"
                                        class="form-select form-select-solid w-350px ps-15"
                                        data-placeholder="اختر">
                                    <option value="">كافة المراحل التعليمية</option>
                                    @foreach($classRooms as $value)
                                        <option value="{{ $value->id }}">{{ $value->name }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group mb-3">
                                <label for="status">الحالة</label>
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" value="1" wire:model="status" id="status" @if($status) checked @endif />
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-paper-plane"></i> تاكيد
                                </button>
                                <button type="button" class="btn btn-secondary" wire:click="closeModal">الغاء</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Modal for Delete Confirmation -->
    @if($isDeleteConfirmationOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">حذف الفصل الدراسي</h5>
                        <button type="button" class="btn-close" wire:click="closeDeleteConfirmation" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>هل تريد حذف الشعبة الدراسية ?</p>
                    </div>
                    <div class="modal-footer">
                        <button wire:click="deleteConfirmed" class="btn btn-danger btn-sm">
                            <i class="fa fa-trash"></i> حذف
                        </button>
                        <button type="button" class="btn btn-secondary" wire:click="closeDeleteConfirmation">الغاء</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    @if($isCalendarModalOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Calendar</h5>
                        <button type="button" class="btn-close" wire:click="closeCalendarModal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <!-- Calendar Container -->
                        <div id="kt_docs_fullcalendar_basic"></div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeCalendarModal">Close</button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif


</div>



