@section('title','-الامتحان')
<div id="kt_content_container" class="container-xxl">
    <!--begin::Card-->
    <div class="card">
        <!--begin::Card header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Card title-->
            <div class="card-title">
                كافة الامتحانات الدراسية
            </div>
            <!--begin::Card title-->
            <!--begin::Card toolbar-->
            <div class="card-toolbar">
                <!--begin::Toolbar-->
                <div class="d-flex justify-content-end" data-kt-customer-table-toolbar="base">
                    <!--begin::Filter-->

{{--                    @if(auth('admin')->user()->can('add_exam'))--}}
                        <button type="button"  wire:click="openModal" class="btn btn-primary" data-bs-toggle="modal">اضافة امتحان  جديدة</button>
{{--                    @endif--}}
                    <!--end::Add customer-->
                </div>
                <!--end::Toolbar-->
                <!--begin::Group actions-->
                <div class="d-flex justify-content-end align-items-center d-none" data-kt-customer-table-toolbar="selected">
                    <div class="fw-bolder me-5">
                        <span class="me-2" data-kt-customer-table-select="selected_count"></span>Selected</div>
                    <button type="button" class="btn btn-danger" data-kt-customer-table-select="delete_selected">Delete Selected</button>
                </div>
                <!--end::Group actions-->
            </div>
            <!--end::Card toolbar-->
        </div>
        <!--end::Card header-->
        <!--begin::Card body-->
        <div class="card-body pt-0">
            <div class="row">

                <div class="col-sm-12 col-lg-1">
                    <div>
                        {{-- <label for="per_page">اظهار</label> --}}
                        <select wire:model.live.debounce.250ms="perPage"
                                class=" custom-select form-control form-control form-control-sm d-inline w-auto form-select form-select-sm form-select-solid">
                            <option value="10">10</option>
                            <option value="20">20</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                            <option value="250">250</option>
                        </select>
                        {{-- <label for="per_page">عرض</label> --}}

                    </div>

                </div>
                <div class="col-sm-12 col-lg-3">

                    <div class="d-flex align-items-center position-relative" >
                        <select name="class_room_id"
                                wire:model="classRoomId" wire:change="onClassRoomChange"
                                class="form-select form-select-solid form-control form-control-solid w-250px ps-15"
                                data-placeholder="اختر">
                            <option value=""> المراحل التعليمية</option>
                            @foreach($classRooms as $value)
                                <option value="{{$value->id}}">{{$value->name}}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
                <div class="col-sm-12 col-lg-3">


                    <!-- Material Selection -->
                    <div class="d-flex align-items-center position-relative my-1 " style="margin-right: 2%">
                        <select name="materialId" wire:change="onMaterialChange"
                                wire:model.live="materialId"
                                class="form-select form-select-solid form-control form-control-solid w-250px"
                                aria-label="Select Material">
                            <option value="">اختر</option>
                            @foreach($materials as $value)
                                <option value="{{ $value->id }}">{{ $value->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-lg-2">

                </div>

                <div class="col-sm-12 col-lg-1" >
                    <div class="d-flex align-items-center position-relative my-1">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                        <span class="svg-icon svg-icon-1 position-absolute ms-6">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2"
                                      rx="1" transform="rotate(45 17.0365 15.1223)" fill="currentColor" />
                                <path
                                    d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z"
                                    fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                        <input type="text" wire:model.live.debounce.250ms="search"
                               class="form-control form-control-solid w-250px ps-15" placeholder="Search" />
                    </div>

                </div>
            </div>
            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr>
                    <th  class="min-w-125px" wire:click="sortBy('name')" style="cursor: pointer;">
                        الاسم
                        @if($sortField === 'name')
                            <i class="fa fa-sort-{{ $sortDirection }}"></i>
                        @endif
                    </th>
                    <th   class="min-w-125px">الصف الدراسي</th>

                    <th   class="min-w-125px">المادة الدراسية</th>
                    <th   class="min-w-125px">عدد الاسئلة</th>

                    <th   class="min-w-125px">العمليات</th>
                </tr>
                </thead>
                <tbody>
                @foreach($exams as $value)
                    <tr>
                        <td>{{ $value->name }}</td>

                        <td>{{ $value->classRooms?$value->classRooms->name:'' }}</td>
                        <td>{{ $value->materials?$value->materials->name:'' }}</td>
                        <td>{{ $value->question_count }}</td>

                        <td>



{{--                            @if(auth('admin')->user()->can('edit_exam'))--}}

                                <a wire:click="openModal({{ $value->id }})" class="btn btn-primary btn-sm" title="تعديل الامتحان">
                                    <i class="fa fa-edit"></i>
                                </a>
{{--                            @endif--}}


{{--                            @if(auth('admin')->user()->can('delete_exam'))--}}
                                <a wire:click="confirmDelete({{ $value->id }})" class="btn btn-danger btn-sm" title="حذف الامتحان">
                                    <i class="fa fa-trash"></i>
                                </a>

{{--                            @endif--}}


                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <!-- Pagination Links -->
            <div class="mt-4">
                {{ $exams->links('vendor.livewire.bootstrap') }}
            </div>
        </div>
    </div>

    <!-- Modal for Edit/Create Governorate -->
    @if($isModalOpen)
        <div class="modal fade show" tabindex="-1" role="dialog" aria-labelledby="modalLabel" style="display: block;" aria-modal="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">{{ $examId ? 'تعديل بيانات الامتحان' : 'اضافة امتحان جديد' }}</h5>
                        <button type="button" class="btn-close" wire:click="closeModal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">
                            <div class="form-group mb-3 row">
                                <div class="col-lg-12 col-sm-12">
                                    <label for="name" class="form-label">
                                        الاسم
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" id="name" wire:model="name" class="form-control form-control-solid" >
                                    @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div>

                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="classRoomId" class="form-label">
                                        الفصل الدراسي
                                        <span class="required"></span>
                                    </label>
                                    <select class="form-select select2-container" wire:model="classRoomId" wire:change="onClassRoomChange">
                                        <option value="">اختر</option>
                                        @foreach($classRooms as $value)
                                            <option value="{{ $value->id }}">{{ $value->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('classRoomId')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="col-lg-6 col-sm-12">
                                    <label for="materialId" class="form-label">
                                        المادة الدراسية
                                        <span class="required"></span>
                                    </label>
                                    <select class="form-select select2-container" wire:model="materialId" wire:change="onMaterialChange">
                                        <option value="">اختر</option>
                                        @foreach($materials as $value)
                                            <option value="{{ $value->id }}">{{ $value->name }}</option>
                                        @endforeach
                                    </select>
                                    @error('materialId')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>


                            </div>
                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="question_count" class="form-label">
                                        عدد الاسئلة
                                        <span class="required"></span>
                                    </label>
                                    <input type="number" min="1" value="" id="question_count" wire:model="question_count" class="form-control form-control-solid" >
                                    @error('question_count')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <label for="exam_time" class="form-label">
                                        وقت الامتحان
                                        <span class="required"></span>
                                    </label>
                                    <input type="number" min="1" value="" id="exam_time" wire:model="exam_time" class="form-control form-control-solid" >
                                    @error('exam_time')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div>

                        @if($chapters)
                            <div class="form-group mb-3 row">
                                <label class="form-label">الفصول المادة الدراسية <span class="required"></span></label>
                                @foreach($chapters as $value)
                                    <div class="col-lg-4 mt-1 mb-1">
                                        <div class="form-check">
                                            <!-- Bind the checkboxes to chapterIds array in Livewire -->
                                            <input class="form-check-input" type="checkbox" value="{{ $value->id }}" wire:model="chapterIds">

                                            <label class="form-check-label">
                                                {{ $value->title }}
                                                <br>
                                                (  عدد الاسئلة:    {{ $value->questions() }})
                                            </label>
                                        </div>
                                    </div>
                                @endforeach
                                @error('chapterIds')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                            @endif
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-paper-plane"></i> تأكيد</button>
                                <button type="button" class="btn btn-secondary btn-sm" wire:click="closeModal">إلغاء</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal-backdrop fade show"></div>
    @endif




















    <!-- Modal for Delete Confirmation -->
    @if($isDeleteConfirmationOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog" aria-labelledby="deleteConfirmLabel" aria-modal="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteConfirmLabel">حذف</h5>
                        <button type="button" class="close" wire:click="closeDeleteConfirmation" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>هل انت متاكد من عملية حذف الامتحان </p>
                    </div>
                    <div class="modal-footer">
                        <button wire:click="deleteConfirmed" class="btn btn-danger btn-sm">
                            <i class="fa fa-trash"></i> تاكيد
                        </button>
                        <button type="button" class="btn btn-secondary btn-sm" wire:click="closeDeleteConfirmation">الغاء</button>

                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>
