<div class="container mt-4">
    <!-- Search Input -->

    <!-- Table -->
    <div class="card card-flush">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title">Grades List</h3>
            <button type="button" class="btn btn-success" wire:click="openModal">
                <i class="fa fa-plus"></i> Add Grade
            </button>
        </div>

        <div class="card-body">
            <div class="mb-4">
                <input type="text"
                       wire:model.live.debounce.250ms="search"
                       class="form-control form-control-solid"
                       placeholder="Search by name...">
            </div>

            <table class="table table-striped table-bordered">
                <thead>
                <tr>
                    <th>
                        Name
                        @if($sortField === 'name')
                            <i class="fa fa-sort-{{ $sortDirection }}"></i>
                        @endif
                    </th>
                    <th>Note</th>
                    <th>Actions</th>
                </tr>
                </thead>
                <tbody>
                @foreach($grades as $grade)
                    <tr>
                        <td>{{ $grade->name }}</td>
                        <td>{{ $grade->note }}</td>
                        <td>
                            <button wire:click="openModal({{ $grade->id }})" class="btn btn-primary btn-sm">
                                <i class="fa fa-edit"></i> Edit
                            </button>
                            <button wire:click="confirmDelete({{ $grade->id }})" class="btn btn-danger btn-sm">
                                <i class="fa fa-trash"></i> Delete
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <!-- Pagination Links -->
            <div class="mt-4">
                {{ $grades->links('vendor.livewire.bootstrap') }}
            </div>
        </div>
    </div>

    <!-- Modal for Edit/Create Grade -->
    @if($isModalOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{ $gradeId ? 'Edit Grade' : 'Add New Grade' }}</h5>
                        <button type="button" class="close" wire:click="closeModal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">
                            <div class="form-group">
                                <label for="name-ar">Name (AR)</label>
                                <input type="text" id="name-ar" wire:model="name.ar" class="form-control">
                                @error('name.ar') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="name-en">Name (EN)</label>
                                <input type="text" id="name-en" wire:model="name.en" class="form-control">
                                @error('name.en') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="form-group">
                                <label for="note">Note</label>
                                <textarea id="note" wire:model="note" class="form-control"></textarea>
                                @error('note') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" wire:click="closeModal">Close</button>
                                <button type="submit" class="btn btn-primary">Save changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Modal for Delete Confirmation -->
    @if($isDeleteConfirmationOpen)
        <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Confirm Delete</h5>
                        <button type="button" class="close" wire:click="closeDeleteConfirmation" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to delete this grade?</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="closeDeleteConfirmation">Cancel</button>
                        <button wire:click="deleteConfirmed" class="btn btn-danger btn-sm">
                            <i class="fa fa-trash"></i> Delete
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-backdrop fade show"></div>
    @endif
</div>
