@section('title', '-الدروس التعليمية')
<div id="kt_content_container" class="container-xxl">
    <!--begin::Card-->
    <div class="card">
        <!--begin::Card header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Card title-->
            <div class="card-title">
                كافة الدروس التعليمية
            </div>
            <!--begin::Card title-->
            <!--begin::Card toolbar-->
            <div class="card-toolbar">
                <!--begin::Toolbar-->
                <div class="d-flex justify-content-end" data-kt-customer-table-toolbar="base">
                    <!--begin::Filter-->

                    @if (auth('admin')->user()->can('add_lesson'))
                        <button type="button" wire:click="openModal" class="btn btn-primary" data-bs-toggle="modal">اضافة
                            مادة داراسية جديدة</button>
                    @endif
                    <!--end::Add customer-->
                </div>
                <!--end::Toolbar-->
                <!--begin::Group actions-->
                <div class="d-flex justify-content-end align-items-center d-none"
                    data-kt-customer-table-toolbar="selected">
                    <div class="fw-bolder me-5">
                        <span class="me-2" data-kt-customer-table-select="selected_count"></span>Selected
                    </div>
                    <button type="button" class="btn btn-danger" data-kt-customer-table-select="delete_selected">Delete
                        Selected</button>
                </div>
                <!--end::Group actions-->
            </div>
            <!--end::Card toolbar-->
        </div>
        <!--end::Card header-->
        <!--begin::Card body-->
        <div class="card-body pt-0">
            <div class="row">

                <div class="col-sm-12 col-lg-1">
                    <div>
                        {{-- <label for="per_page">اظهار</label> --}}
                        <select wire:model.live.debounce.250ms="perPage"
                            class=" custom-select form-control form-control form-control-sm d-inline w-auto form-select form-select-sm form-select-solid">
                            <option value="10">10</option>
                            <option value="20">20</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                            <option value="250">250</option>
                        </select>
                        {{-- <label for="per_page">عرض</label> --}}

                    </div>

                </div>
                <div class="col-sm-12 col-lg-3">

                    <div class="d-flex align-items-center position-relative">
                        <select name="search_class_room_id" wire:model="search_class_room_id"
                            wire:change="onClassRoomSerachChange"
                            class="form-select form-select-solid form-control form-control-solid w-250px ps-15"
                            data-placeholder="اختر">
                            <option value="">المراحل التعليمية</option>
                            @foreach ($classRooms as $value)
                                <option value="{{ $value->id }}">{{ $value->name }}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
                <div class="col-sm-12 col-lg-3">


                    <!-- Material Selection -->
                    <div class="d-flex align-items-center position-relative my-1 " style="margin-right: 2%">
                        <select name="search_material_id" wire:change="onMaterialSerachChange"
                            wire:model.live="search_material_id"
                            class="form-select form-select-solid form-control form-control-solid w-250px"
                            aria-label="Select Material">
                            <option value="">المواد التعليمية</option>
                            @foreach ($search_materials as $value)
                                <option value="{{ $value->id }}">{{ $value->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-lg-3">


                    <!-- Material Selection -->
                    <div class="d-flex align-items-center position-relative my-1 " style="margin-right: 2%">
                        <select name="search_material_id" wire:model.live="search_chapter_id"
                            class="form-select form-select-solid w-250px ps-15" aria-label="Select Material">
                            <option value="">الوحدات التعليمية</option>
                            @foreach ($search_chapters as $value)
                                <option value="{{ $value->id }}">{{ $value->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <div class="col-sm-12 col-lg-1">
                    <div class="d-flex align-items-center position-relative my-1">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                        <span class="svg-icon svg-icon-1 position-absolute ms-6">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                fill="none">
                                <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2"
                                    rx="1" transform="rotate(45 17.0365 15.1223)" fill="currentColor" />
                                <path
                                    d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z"
                                    fill="currentColor" />
                            </svg>
                        </span>
                        <!--end::Svg Icon-->
                        <input type="text" wire:model.live.debounce.250ms="search"
                            class="form-control form-control-solid w-250px ps-15" placeholder="Search" />
                    </div>

                </div>
            </div>
            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                    <tr>
                        <th class="min-w-125px" wire:click="sortBy('name')" style="cursor: pointer;">
                            الاسم
                            @if ($sortField === 'name')
                                <i class="fa fa-sort-{{ $sortDirection }}"></i>
                            @endif
                        </th>
                        <th class="min-w-125px">الوحدة الدراسية</th>
                        <th class="min-w-125px">المادة الدراسية</th>
                        <th class="min-w-125px">الصف الدراسي</th>


                        <th class="min-w-125px">العمليات</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($lessons_list as $value)
                        <tr>
                            <td>{{ $value->name }}</td>
                            <td>{{ $value->chapters ? $value->chapters->name : '' }}</td>
                            <td>{{ $value->materials ? $value->materials->name : '' }}</td>

                            <td>{{ $value->materials ? ($value->materials->classRooms ? $value->materials->classRooms->name : '') : '' }}
                            </td>

                            <td>
                                @if ($value->attachment)
                                    <a wire:click="openVideoModal({{ $value->id }})" class="btn btn-warning btn-sm"
                                        title="عرض كافة الاسئلة">
                                        <i class="fa fa-play" aria-hidden="true"></i>
                                    </a>
                                @endif
                                <a wire:click="openAllQuestionModal({{ $value->id }})"
                                    class="btn btn-secondary btn-sm" title="عرض كافة الاسئلة">
                                    <i class="fa-solid fa-question" aria-hidden="true"></i>
                                </a>
                                <a wire:click="openExcelModal({{ $value->id }})" class="btn btn-dark btn-sm"
                                    title="تصدير الاسئلة اكسل">
                                    <i class="fa fa-upload" aria-hidden="true"></i>
                                </a>
                                <a wire:click="openModalQuestion({{ $value->id }})" class="btn btn-success btn-sm"
                                    title="اضافة اسئلة">
                                    <i class="fa fa-plus"></i>
                                </a>
                                @if (auth('admin')->user()->can('edit_lesson'))
                                    <a wire:click="openModal({{ $value->id }})" class="btn btn-primary btn-sm"
                                        title="تعديل الدرس">
                                        <i class="fa fa-edit"></i>
                                    </a>
                                @endif


                                @if (auth('admin')->user()->can('delete_lesson'))
                                    <a wire:click="confirmDelete({{ $value->id }})" class="btn btn-danger btn-sm"
                                        title="حذف الدرس">
                                        <i class="fa fa-trash"></i>
                                    </a>
                                @endif


                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <!-- Pagination Links -->
            <div class="mt-4">
                {{ $lessons_list->links('vendor.livewire.bootstrap') }}
            </div>
        </div>
    </div>

    <!-- Modal for Edit/Create Governorate -->
    @if ($isModalOpen)
        <div class="modal fade @if ($isModalOpen) show @endif" tabindex="-1" role="dialog"
            aria-labelledby="modalLabel" @if ($isModalOpen) style="display: block;" @endif
            aria-modal="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">
                            {{ $materialId ? 'تعديل بيانات الدروس التعليمية' : 'اضافة بيانات الدروس التعليمية' }}</h5>
                        <button type="button" class="btn-close" wire:click="closeModal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="save">


                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="name" class="form-label">

                                        الكود
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" name="code" id="code" wire:model="code"
                                        class="form-control form-control-solid">
                                    @error('code')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>

                                <div class="col-lg-6 col-sm-12">
                                    <label for="name" class="form-label">

                                        الاسم
                                        <span class="required"></span>
                                    </label>
                                    <input type="text" id="name" wire:model="name"
                                        class="form-control form-control-solid">
                                    @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>

                            </div>
                            <div class="form-group mb-3 row">

                                <textarea id="description" wire:model="description" class="form-control form-control-solid"></textarea>

                            </div>
                            <div class="form-group mb-3 row">
                                <div class="col-lg-6 col-sm-12">
                                    <label for="materialId" class="form-label">

                                        الفصل الدراسي
                                        <span class="required"></span>
                                    </label>
                                    <select class="form-select select2-container" data-control="select2"
                                        name="classRoomId" id="classRoomId" wire:model="classRoomId">

                                        <option value="">اختر</option>
                                        @foreach ($classRooms as $value)
                                            <option value="{{ $value->id }}"
                                                @if ($value->id == $classRoomId) selected @endif>{{ $value->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                    @error('classRoomId')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>

                                <div class="col-lg-6 col-sm-12">
                                    <label for="materialId" class="form-label">

                                        المادة الدراسية
                                        <span class="required"></span>
                                    </label>
                                    <select class="form-select select2-container" data-control="select2"
                                        name="materialId" id="materialId" wire:model="materialId"
                                        wire:change="onMaterialChange">

                                        <option value="">اختر</option>
                                        @foreach ($materials as $value)
                                            <option value="{{ $value->id }}"
                                                @if ($value->id == $materialId) selected @endif>{{ $value->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                    @error('materialId')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>

                                <div class="col-lg-6 col-sm-12">
                                    <label for="chapterId" class="form-label">

                                        الفصول المادة الدرسية
                                        <span class="required"></span>
                                    </label>
                                    <select class="form-select select2-container" data-control="select2"
                                        name="chapterId" id="chapterId" wire:model="chapterId">

                                        <option value="">اختر</option>
                                        @foreach ($chapters as $value)
                                            <option value="{{ $value->id }}"
                                                @if ($value->id == $chapterId) selected @endif>{{ $value->name }}
                                            </option>
                                        @endforeach
                                    </select>

                                    @error('chapterId')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                </div>
                                <div class="col-lg-6 col-sm-12">
                                    <label for="video" class="form-label">إرفاق فيديو</label>
                                    <input type="text" id="video" wire:model="attachment"
                                        class="form-control form-control-solid">
                                    @error('attachment')
                                        <span class="text-danger">{{ $message }}</span>
                                    @enderror

                                    <!-- Display loading state -->


                                    <!-- Display video preview only when the upload is complete -->
                                    {{--                                    <div wire:loading.remove wire:target="attachment"> --}}

                                    @if ($existingVideoPath)

                                        <video width="100%" controls class="m-1"
                                            style="width: 150px; height: 150px">
                                            <source src="{{ asset('storage/' . $existingVideoPath) }}"
                                                type="video/mp4">
                                            متصفحك لا يدعم تشغيل الفيديو.
                                        </video>
                                    @endif



                                    {{--                                    </div> --}}
                                </div>

                            </div>


                            <div class="form-group mb-3">
                                <label for="status">الحالة</label>
                                <div class="form-check form-switch">


                                    <input class="form-check-input" @if ($status == 1) checked @endif
                                        type="checkbox" value="1" wire:model="status" id="status" />
                                </div>
                            </div>



                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary btn-sm"> <i
                                        class="fa fa-paper-plane"></i>تاكيد</button>

                                <button type="button" class="btn btn-secondary btn-sm"
                                    wire:click="closeModal">الغاء</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        @if ($isModalOpen)
            <div class="modal-backdrop fade show"></div>
        @endif

    @endif



    @if ($showVideoModal)
        <div class="modal fade @if ($showVideoModal) show @endif" tabindex="-1" role="dialog"
            aria-labelledby="modalLabel" @if ($showVideoModal) style="display: block;" @endif
            aria-modal="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">عرض الفيديو</h5>
                        <button type="button" class="btn-close" wire:click="closeVideoModal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body text-center">
                        <video class="w-100" controls>
                            <source src="{{ $vedioUrl }}" type="video/mp4">
                            Your browser does not support the video tag.
                        </video>
                    </div>
                </div>
            </div>
        </div>

        @if ($showVideoModal)
            <div class="modal-backdrop fade show"></div>
        @endif
    @endif


    @if ($showListQuestion)
        <div class="modal fade @if ($showListQuestion) show @endif" tabindex="-1" role="dialog"
            aria-labelledby="modalLabel" @if ($showListQuestion) style="display: block;" @endif
            aria-modal="true">
            <div class="modal-dialog-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">عرض كافة الاسئلة</h5>
                        <button type="button" class="btn-close" wire:click="closeListQuestionModal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">

                        <table class="table align-middle table-row-dashed fs-6 gy-5">
                            <thead>
                                <tr>
                                    <th class="min-w-125px">
                                        السؤال

                                    </th>
                                    <th class="min-w-125px">عنوان الدرس</th>


                                    <th class="min-w-125px">العمليات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($questions as $value)
                                    <tr>
                                        <td>{{ $value->questions }}</td>
                                        <td>{{ $value->lessons ? $value->lessons->name : '' }}</td>

                                        <td>




                                            <a wire:click="openQuestionModal({{ $value->id }})"
                                                class="btn btn-primary btn-sm" title="تعديل السؤال">
                                                <i class="fa fa-edit"></i>
                                            </a>


                                            <a wire:click="confirmQuestionDelete({{ $value->id }})"
                                                class="btn btn-danger btn-sm" title="حذف السؤال">
                                                <i class="fa fa-trash"></i>
                                            </a>





                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>

                    </div>
                </div>
            </div>
        </div>

        @if ($showListQuestion)
            <div class="modal-backdrop fade show"></div>
        @endif

    @endif

    @if ($isQuestionModalOpen)
        <div class="modal fade @if ($isQuestionModalOpen) show @endif" tabindex="-1" role="dialog"
            aria-labelledby="modalLabel" @if ($isQuestionModalOpen) style="display: block;" @endif
            aria-modal="true">
            <div class="modal-dialog-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">اسئلة الدرس </h5>
                        <button type="button" class="btn-close" wire:click="closeAnswerModal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="saveQuestion">
                            <!-- Chapter Repeater -->



                            <div class="form-group row">

                                <div class="col-6">
                                    <label class="form-label">السؤال:</label>
                                    <input type="text" class="form-control mb-2 mb-md-0" wire:model="question" />

                                    <input type="hidden" class="form-control mb-2 mb-md-0" wire:model="lessonId" />
                                </div>

                                <div class="col-6">
                                    <label class="form-label"> مرفق:</label>
                                    <input type="file" accept="image/*" class="form-control mb-2 mb-md-0"
                                        wire:model="question_attachment" />
                                </div>
                            </div>
                            <input type="hidden" class="form-control mb-2 mb-md-0" wire:model="lessonId">
                            {{-- @foreach ($answers as $index => $value) --}}
                                <div class="form-group row" wire:key="answers-{{ $index }}">
                                    <div class="col-6">
                                        <label class="form-label">الاجابة:</label>
                                        <input type="text" class="form-control mb-2 mb-md-0"
                                            wire:model="answers.{{ $index }}.name" />
                                    </div>
                                    <div class="col-3">
                                        <label for="status">الاجابة الصحيحة</label>
                                        <br>
                                        <div class="form-check form-switch mt-5">
                                            <input class="form-check-input" type="checkbox"
                                                wire:model="answers.{{ $index }}.is_correct"
                                                id="is_correct_{{ $index }}"
                                                wire:click="toggleAnswerCorrect({{ $index }})" />
                                        </div>
                                    </div>
                                    <div class="col-3">
                                        <button type="button" class="btn btn-sm btn-light-danger mt-3 mt-md-8"
                                            wire:click="removeAnswerRow({{ $index }})">
                                            <i class="la la-trash-o"></i> حذف
                                        </button>
                                    </div>
                                </div>
                            {{-- @endforeach --}}




                            <div class="form-group mt-5">
                                <button type="button" class="btn btn-light-primary" wire:click="addAnswerRow">
                                    <i class="la la-plus"></i> اضافة
                                </button>
                            </div>

                            <!-- Submit Button -->
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary btn-sm">
                                    <i class="fa fa-paper-plane"></i> تاكيد
                                </button>
                                <button type="button" class="btn btn-secondary btn-sm"
                                    wire:click="closeAnswerModal">الغاء</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        @if ($isQuestionModalOpen)
            <div class="modal-backdrop fade show"></div>
        @endif

    @endif



    @if ($isEditQuestionModalOpen)
        <div class="modal fade @if ($isEditQuestionModalOpen) show @endif" tabindex="-1" role="dialog"
            aria-labelledby="modalLabel" @if ($isEditQuestionModalOpen) style="display: block;" @endif
            aria-modal="true">
            <div class="modal-dialog-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="modalLabel">تعديل اسئلة الدرس</h5>
                        <button type="button" class="btn-close" wire:click="closeEditAnswerModal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form wire:submit.prevent="saveEditQuestion">
                            <!-- Chapter Repeater -->



                            <div class="form-group row">

                                <div class="col-6">
                                    <label class="form-label">السؤال:</label>
                                    <input type="text" class="form-control mb-2 mb-md-0"
                                        wire:model="edit_questions" />

                                    @error('edit_questions')
                                        <span class="text-danger">{{ $message }}</span>

        @endif

        <input type="hidden" class="form-control mb-2 mb-md-0" wire:model="edit_question_id" />
    </div>

    <div class="col-6">
        <label class="form-label"> مرفق:</label>
        <input type="file" accept="image/*" class="form-control mb-2 mb-md-0"
            wire:model="edit_question_attachment" />

        @if ($show_question_attachment)
            <img src="{{ asset('storage/' . $show_question_attachment) }}" style="width: 100px">
        @endif
    </div>
    </div>
    @foreach ($edit_answers as $index => $value)
        <div class="form-group row" wire:key="edit_answers-{{ $index }}">
            <div class="col-6">
                <label class="form-label">الاجابة:</label>
                <input type="text" class="form-control mb-2 mb-md-0"
                    wire:model="edit_answers.{{ $index }}.name" value="{{ $value->answer }}" />
                @error('edit_answers.*.name')
                    <span class="text-danger">{{ $message }}</span>

        @endif


        </div>
        <div class="col-3">
            <label for="status">الاجابة الصحيحة</label>
            <br>
            <div class="form-check form-switch mt-5">
                <input class="form-check-input" type="checkbox" wire:model="edit_answers.{{ $index }}.is_correct"
                    id="is_correct_{{ $index }}" @if ($value->is_correct) checked @endif
                    wire:click="toggleAnswerCorrect({{ $index }})" />

                @error('edit_answers.*.is_correct')
                    <span class="text-danger">{{ $message }}</span>

                    @endif
                </div>
            </div>
            </div>
            @endforeach






            <!-- Submit Button -->
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary btn-sm">
                    <i class="fa fa-paper-plane"></i> تاكيد
                </button>
            </div>
            </form>
            </div>
            </div>
            </div>
            </div>

            @if ($isEditQuestionModalOpen)
                <div class="modal-backdrop fade show"></div>
            @endif

            @endif

            @if ($isDeleteQuestionConfirmationOpen)
                <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog"
                    aria-labelledby="deleteConfirmLabel" aria-modal="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteConfirmLabel">حذف</h5>
                                <button type="button" class="close" wire:click="closeQuestionDeleteConfirmation"
                                    aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <p>هل انت متاكد من عملية حذف السؤال</p>
                            </div>
                            <div class="modal-footer">
                                <button wire:click="deleteQuestionConfirmed" class="btn btn-danger btn-sm">
                                    <i class="fa fa-trash"></i> تاكيد
                                </button>
                                <button type="button" class="btn btn-secondary btn-sm"
                                    wire:click="closeQuestionDeleteConfirmation">الغاء</button>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-backdrop fade show"></div>
            @endif


            @if ($isExcelModalOpen)
                <div class="modal fade show" tabindex="-1" role="dialog" aria-labelledby="excelModalLabel"
                    style="display: block;" aria-modal="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="excelModalLabel">رفع ملف Excel</h5>
                                <button type="button" class="btn-close" wire:click="closeExcelModal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form wire:submit.prevent="uploadExcel" enctype="multipart/form-data">
                                    <div class="form-group mb-3 text-center">
                                        <label class="form-label">تنزيل نموذج الاكسل</label>
                                        <a href="{{ asset('storage/uploads/questions.xlsx') }}" target="_blank"
                                            style="color: #D39494">
                                            <svg fill="#000000" width="50px" height="50px" viewBox="0 0 16 16"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M7 5.222V0h2v5.193l1.107-1.107L11.52 5.5 7.986 9.036 4.45 5.5l1.414-1.414L7 5.222zM16 11v5H0v-5h2v3h12v-3h2z"
                                                    fill-rule="evenodd" />
                                            </svg>
                                        </a>
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="excelFile" class="form-label">اختر ملف Excel</label>
                                        <input type="file" id="excelFile" wire:model="file" class="form-control">
                                        @error('file')
                                            <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary btn-sm"><i
                                                class="fa fa-paper-plane"></i>رفع</button>
                                        <button type="button" class="btn btn-secondary btn-sm"
                                            wire:click="closeExcelModal">الغاء</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-backdrop fade show"></div>
            @endif





            <!-- Modal for Delete Confirmation -->
            @if ($isDeleteConfirmationOpen)
                <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog"
                    aria-labelledby="deleteConfirmLabel" aria-modal="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteConfirmLabel">حذف</h5>
                                <button type="button" class="close" wire:click="closeDeleteConfirmation" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <p>هل انت متاكد من عملية حذف الدرس التعليمية</p>
                            </div>
                            <div class="modal-footer">
                                <button wire:click="deleteConfirmed" class="btn btn-danger btn-sm">
                                    <i class="fa fa-trash"></i> تاكيد
                                </button>
                                <button type="button" class="btn btn-secondary btn-sm"
                                    wire:click="closeDeleteConfirmation">الغاء</button>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-backdrop fade show"></div>
            @endif
            </div>
