<div>
    <form wire:submit.prevent="save">
        @foreach ($questions as $index => $question)
            <div class="mb-4">
                <label>Question:</label>
                <input type="text" wire:model="questions.{{ $index }}.text" placeholder="Question text" class="form-control" required>

                <div>
                    <label>Choices:</label>
                    @foreach ($question['choices'] as $choiceIndex => $choice)
                        <div class="d-flex align-items-center mb-2">
                            <input type="text" wire:model="questions.{{ $index }}.choices.{{ $choiceIndex }}.text" placeholder="Choice text" class="form-control" required>
                            <input type="checkbox" wire:model="questions.{{ $index }}.choices.{{ $choiceIndex }}.is_correct">
                            <span class="ml-2">Correct</span>
                            <button type="button" wire:click="addChoice({{ $index }})" class="btn btn-secondary btn-sm ml-2">Add Choice</button>
                        </div>
                    @endforeach
                </div>
            </div>
        @endforeach

        <button type="button" wire:click="addQuestion" class="btn btn-primary">Add Question</button>
        <button type="submit" class="btn btn-success">Save Questions</button>
    </form>

    @if (session()->has('message'))
        <div class="alert alert-success mt-4">{{ session('message') }}</div>
    @endif
</div>

