@section('title','- الصلاحيات')

<div id="kt_content_container" class="container-xxl">
    <div class="card">
        <div class="card-header border-0 pt-6">
            <div class="card-title">
            عرض كافة الصلاحيات
            </div>
            <div class="card-toolbar">
                @if(auth('admin')->user()->can('add_role'))

                <div class="d-flex justify-content-end" data-kt-customer-table-toolbar="base">
                    <button wire:click="create()" class="btn btn-primary">اضافة صلاحية جديدة</button>
                </div>
                @endif
            </div>
        </div>
        <div class="card-body pt-0">
            <div class="row">
                <div class="col-sm-12 col-md-9" style="float:right">
                    <div>
                        <label for="per_page">عرض</label>
                        <select wire:model.live.debounce.250ms="perPage" class=" custom-select form-control form-control form-control-sm d-inline w-auto form-select form-select-sm form-select-solid">
                            <option value="10">10</option>
                            <option value="20">20</option>
                            <option value="50">50</option>
                            <option value="100">100</option>
                            <option value="250">250</option>
                        </select>
                    </div>
                </div>
                <div class="col-sm-12 col-md-3" style="float:left" >
                    <div class="d-flex align-items-center position-relative my-1">
                        <!--begin::Svg Icon | path: icons/duotune/general/gen021.svg-->
                        <span class="svg-icon svg-icon-1 position-absolute ms-6">
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                                                            <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="currentColor" />
                                                            <path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="currentColor" />
                                                        </svg>
                                                    </span>
                        <!--end::Svg Icon-->
                        <input type="text"
                               wire:model.live.debounce.250ms="search"

                               class="form-control form-control-solid w-250px ps-15" placeholder="Search" />
                    </div>

                </div>
                </div>


            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr>
                    <th>الاسم</th>
                    @if(auth('admin')->user()->can('edit_role'))
                    <th>العمليات</th>
                        @endif
                </tr>
                </thead>
                <tbody>
                @foreach($roles as $value)
                    <tr>
                        <td>{{ $value->name }}</td>
{{--                        @if(auth('admin')->user()->can('edit_role'))--}}

                        <td>

                            <button wire:click="edit({{ $value->id }})" class="btn btn-primary btn-sm">
                                <i class="fa fa-edit"></i> تعديل


                            </button>



                        </td>
{{--                            @endif--}}
                    </tr>
                @endforeach
                </tbody>
            </table>

            <!-- Modal -->

            <div class="modal fade @if($isOpen) show @endif" tabindex="-1" style="display: @if($isOpen) block @else none @endif;">
                <div class="modal-dialog modal-xl">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">{{ $roleId ? 'تعديل الصلاحيات' : 'اضافة صلاحية جديدة' }}</h5>
                            <button type="button" class="close" wire:click="$set('isOpen', false)">&times;</button>
                        </div>
                        <div class="modal-body">
                            <form>
                                <div class="form-row row m-1">
                                    <div class="form-group col-lg-12">
                                        <label for="name">الاسم</label>
                                        <input type="text" id="name" wire:model="name" class="form-control" required>
                                        @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="form-row row m-1">
                                    @foreach($permission as $value)
                                        <h5>{{ $value->name }}</h5>
                                        <div class="row mt-1">

                                        @foreach($value->permissionElements as $element)
                                                <div class="col-md-3 col-sm-6 mb-2">
                                                    <div class="form-check form-switch">
                                                        <input class="form-check-input" type="checkbox" value="{{ $element->id }}" wire:model="permission_elements" id="permission_elements_{{ $element->id }}" />
                                                        <label class="form-check-label" for="permission_elements_{{ $element->id }}">{{ $element->name }}</label>
                                                    </div>
                                                </div>
                                                {{-- Break after every 4 columns --}}
                                                @if(($loop->iteration % 4) == 0)
{{--                                        </div>--}}
{{--                                        <div class="row">--}}
                                            @endif
                                            @endforeach
                                        </div>
                                        <hr>
                                    @endforeach
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" wire:click="store()">
                                <i class="fa fa-paper-plane"></i> تاكيد
                            </button>
                            <button type="button" class="btn btn-secondary" wire:click="$set('isOpen', false)">الغاء</button>
                        </div>
                    </div>
                </div>
            </div>


            {{ $roles->links('vendor.livewire.bootstrap') }}
        </div>

    </div>
</div>




