<div id="kt_content_container" class="container-xxl">
    <div class="card">
        <div class="card-header border-0 pt-6">
            <div class="card-title">
                <div class="d-flex align-items-center position-relative my-1">
                    <span class="svg-icon svg-icon-1 position-absolute ms-6">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="17.0365" y="15.1223" width="8.15546" height="2" rx="1" transform="rotate(45 17.0365 15.1223)" fill="currentColor" />
                            <path d="M11 19C6.55556 19 3 15.4444 3 11C3 6.55556 6.55556 3 11 3C15.4444 3 19 6.55556 19 11C19 15.4444 15.4444 19 11 19ZM11 5C7.53333 5 5 7.53333 5 11C5 14.4667 7.53333 17 11 17C14.4667 17 17 14.4667 17 11C17 7.53333 14.4667 5 11 5Z" fill="currentColor" />
                        </svg>
                    </span>
                    <input type="text" wire:model.live.debounce.250ms="search" class="form-control form-control-solid w-250px ps-15" placeholder="Search" />
                </div>
            </div>
            <div class="card-toolbar">
                <div class="d-flex justify-content-end" data-kt-customer-table-toolbar="base">
                    @if(auth('admin')->user()->can('excel_student'))

                    <button type="button" wire:click="openExcelModal" class="btn btn-success m-1" data-bs-toggle="modal">استيراد Excel</button>
                                        @endif

                    @if(auth('admin')->user()->can('add_student'))
                    <button wire:click="create()" class="btn btn-primary m-1">اضافة طالب جديد</button>
                    @endif

                </div>
            </div>
        </div>
        <div class="card-body pt-0">
            <table class="table align-middle table-row-dashed fs-6 gy-5">
                <thead>
                <tr>
                    <th>الاسم</th>
                    <th>رقم الهوية</th>
                    <th>المحافظة</th>
                    <th>المنطقة التعليمية</th>
                    <th>المدرسة</th>
                    <th>العمليات</th>
                </tr>
                </thead>
                <tbody>
                @foreach($students as $student)
                    <tr>
                        <td>
                            <a href="{{ route('student', $student->id) }}"  wire:navigate>
                                {{ $student->name }}
                            </a>
                            </td>
                        <td>{{ $student->id_number }}</td>
                        <td>{{ $student->governorate?->name }}</td>
                        <td>{{ $student->educationalArea?->name }}</td>
                        <td>{{ $student->school?->name }}</td>

                        <td>
                            <a href="{{ route('student', $student->id) }}" class="btn btn-success btn-sm" wire:navigate  title="عرض">
                                <i class="fa fa-eye"></i>
                            </a>
                            @if(auth('admin')->user()->can('edit_student'))

                            <button wire:click="edit({{ $student->id }})" class="btn btn-primary btn-sm" title="تعديل">
                                <i class="fa fa-edit"></i>


                            </button>
                            @endif

                                @if(auth('admin')->user()->can('delete_student'))

                            <button wire:click="confirmDelete({{ $student->id }})" class="btn btn-danger btn-sm" title="حذف">
                                <i class="fa fa-trash"></i>
                            </button>
                                @endif
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <!-- Modal -->
            <div class="modal fade @if($isOpen) show @endif" tabindex="-1" style="display: @if($isOpen) block @else none @endif;">
                <div class="modal-dialog modal-lg">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">{{ $student_id ? 'تعديل بيانات الطالب' : ' اضافة طالب جديد' }}</h5>
                            <button type="button" class="close" wire:click="$set('isOpen', false)">&times;</button>
                        </div>
                        <div class="modal-body">
                            <form>
                                <div class="form-row row m-1">
                                    <div class="form-group col-lg-6">
                                        <label for="name">الاسم</label>
                                        <input type="text" id="name" wire:model="name" class="form-control" required>
                                        @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="id_number">رقم الهوية</label>
                                        <input type="text" id="id_number" wire:model="id_number" class="form-control" required>
                                        @error('id_number')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-row row m-1">
                                    <div class="form-group col-lg-6">
                                        <label for="governorate">المحافظة</label>
                                        <select wire:model="governorate_id" class="form-control" id="governorate" required wire:change="onGovernorateIdChange">
                                            <option value="">اختر محافظة</option>
                                            @foreach($governorates as $governorate)
                                                <option value="{{ $governorate->id }}" @if($governorate->id==$governorate_id) selected @endif>{{ $governorate->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('governorate_id')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="educational_area">المنطقة التعليمية</label>
                                        <select wire:model="educational_area_id" class="form-control" id="educational_area" required wire:change="onEducationalAreaIdChange" >
                                            <option value="">اختر منطقة تعليمية</option>
                                            @foreach($educational_areas as $educational_area)
                                                <option value="{{ $educational_area->id }}" @if($educational_area->id==$educational_area_id) selected @endif>{{ $educational_area->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('educational_area_id')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="form-row row m-1">
                                    <div class="form-group col-lg-6">
                                        <label for="school">المدرسة</label>
                                        <select wire:model="school_id" class="form-control" id="school" required>
                                            <option value="">اختر مدرسة</option>
                                            @foreach($schools as $school)
                                                <option value="{{ $school->id }}" @if($school->id==$school_id) selected @endif>{{ $school->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('school_id')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="form-group col-lg-6">
                                        <label for="class_room_id">الصف الدراسي</label>
                                        <select wire:model="class_room_id" class="form-control" id="class_room_id" required wire:change="onClassRoomChange">
                                            <option value="">اختر الصف الدراسي</option>
                                            @foreach($class_rooms as $value)
                                                <option value="{{ $value->id }}" @if($value->id==$class_room_id) selected @endif>{{ $value->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('school_id')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>




                                </div>
                                <div class="form-row row m-1">

                                <div class="col-sm-12 col-lg-6 mb-3">
                                    <label for="class_section_id" class="form-label">الفصل الدراسي</label>
                                    <select wire:model="class_section_id"  class="form-select"  >
                                        <option value="">اختر الشعبة</option>
                                        @foreach($classSections as $value)
                                            <option value="{{ $value->id }}"@if($value->id ==$class_section_id)selected @endif> {{ $value->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-primary" wire:click="store()"><i class="fa fa-paper-plane"></i> تاكيد</button>
                            <button type="button" class="btn btn-secondary" wire:click="$set('isOpen', false)">الغاء</button>


                        </div>
                    </div>
                </div>
            </div>
            @if($isDeleteConfirmationOpen)
                <div class="modal fade show" style="display: block;" tabindex="-1" role="dialog" aria-labelledby="deleteConfirmLabel" aria-modal="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="deleteConfirmLabel">حذف</h5>
                                <button type="button" class="close" wire:click="closeDeleteConfirmation" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <p>هل أنت متأكد أنك تريد حذف هذه الطالب؟</p>
                            </div>
                            <div class="modal-footer">
                                <button wire:click="deleteConfirmed" class="btn btn-danger btn-sm">
                                    <i class="fa fa-trash"></i> تاكيد
                                </button>
                                <button type="button" class="btn btn-secondary btn-sm" wire:click="closeDeleteConfirmation">إلغاء</button>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-backdrop fade show"></div>
            @endif


            @if($isExcelModalOpen)
                <div class="modal fade show" tabindex="-1" role="dialog" aria-labelledby="excelModalLabel" style="display: block;" aria-modal="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="excelModalLabel">رفع ملف Excel</h5>
                                <button type="button" class="btn-close" wire:click="closeExcelModal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form wire:submit.prevent="uploadExcel" enctype="multipart/form-data">
                                    <div class="form-group mb-3 text-center">
                                        <label class="form-label">تنزيل نموذج الاكسل</label>
                                        <a href="{{ asset('storage/uploads/students.xlsx') }}" target="_blank" style="color: #D39494">
                                            <svg fill="#000000" width="50px" height="50px" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M7 5.222V0h2v5.193l1.107-1.107L11.52 5.5 7.986 9.036 4.45 5.5l1.414-1.414L7 5.222zM16 11v5H0v-5h2v3h12v-3h2z" fill-rule="evenodd"/>
                                            </svg>
                                        </a>
                                    </div>
                                    <div class="form-group mb-3">
                                        <label for="excelFile" class="form-label">اختر ملف Excel</label>
                                        <input type="file" id="excelFile" wire:model="file" class="form-control">
                                        @error('file')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-primary btn-sm"><i class="fa fa-paper-plane"></i>رفع</button>
                                        <button type="button" class="btn btn-secondary btn-sm" wire:click="closeExcelModal">الغاء</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-backdrop fade show"></div>
            @endif

            {{ $students->links() }}
        </div>

    </div>
</div>




