<?php

use App\Http\Controllers\Api\Setting\SettingController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::get('settings',[SettingController::class,'index']);

Route::get('get_class_room',[\App\Http\Controllers\Api\SchoolMangments\SchoolController::class,'getClassRoom']);
Route::get('get_information',[\App\Http\Controllers\Api\SchoolMangments\SchoolController::class,'index']);
Route::get('get_all_student',[\App\Http\Controllers\Api\Students\StudentController::class,'get_all_student']);
Route::post('/login',[\App\Http\Controllers\Api\Student\AuthController::class,'login']);
Route::post('/register',[\App\Http\Controllers\Api\Student\AuthController::class,'register']);
Route::get('update_student_not_active',[\App\Http\Controllers\Api\Students\StudentController::class,'update_student_not_active']);


Route::group(['middleware'=>'auth:sanctum'],function (){

    Route::post('/delete_account',[\App\Http\Controllers\Api\Student\AuthController::class,'deleteAccount']);
    Route::group(['prefix'=>'lessons'],function () {

        Route::post('/watch_lessons', [\App\Http\Controllers\Api\Lessons\LessonController::class, 'watch']);
        Route::post('/mark_exam_lessons', [\App\Http\Controllers\Api\Lessons\LessonController::class, 'markLessons']);

    });

    Route::group(['prefix'=>'contests'],function () {

        Route::get('/', [\App\Http\Controllers\Api\Contest\ContestController::class, 'index']);
        Route::get('/single_contest', [\App\Http\Controllers\Api\Contest\ContestController::class, 'singleContest']);
        Route::post('/check_data_contest', [\App\Http\Controllers\Api\Contest\ContestController::class, 'CheckDataContest']);


        Route::post('/finsh-contest', [\App\Http\Controllers\Api\Contest\ContestController::class, 'finshContest']);

    });
    Route::group(['prefix'=>'exam_result'],function () {

        Route::post('/', [\App\Http\Controllers\Api\Exam\ExamController::class, 'store']);

    });
    Route::post('/logout',[\App\Http\Controllers\Api\Student\AuthController::class,'logout']);




});
