<?php

use App\Http\Controllers\Api\Contest\ContestController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Dashboard\Admins\AdminController;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\Dashboard\Profile\ProfileController;
use App\Http\Controllers\Dashboard\Governorates\GovernorateController;
use App\Http\Controllers\Dashboard\EducationAreaes\EducationAreaController;
use App\Http\Controllers\Dashboard\Shcools\ShcoolController;
use App\Http\Controllers\Dashboard\ClassRooms\ClassRoomController;
use App\Http\Controllers\Dashboard\Generals\GemeralController;
use App\Http\Controllers\Dashboard\Lessons\LessonController;
use App\Http\Controllers\Dashboard\Levels\LevelController;
use App\Http\Controllers\Dashboard\Matireals\MatirealsController;
use App\Http\Controllers\Dashboard\Notifications\NotificationController;
use App\Http\Controllers\Dashboard\Roles\RoleController;
use App\Http\Controllers\Dashboard\Settings\SettingController;
use App\Models\Student;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;



Route::get('clear', function () {
    \Illuminate\Support\Facades\Artisan::call('view:cache');

    \Illuminate\Support\Facades\Artisan::call('config:cache');
    \Illuminate\Support\Facades\Artisan::call('config:cache');
    dd('as');
});

Route::get('storages', function () {
    \Illuminate\Support\Facades\Artisan::call('storage:link');
    dd('as');
});

Route::get('Studnent-db', function () {

    Student::query()->create([
        'name' => 'Hassan',
        'id_number' => 1234567810,
        'password' => Hash::make('password'),
        'class_room_id' => 4,
        'governorate_id' => 12,
        'educational_area_id' => 3,
        'school_id' => 10,
    ]);
});

Route::get('admin-logout', [AuthController::class, 'logout'])->name('adminLogout');



Route::get('privacy_policy', [SettingController::class, 'page'])->name('page');
Route::get('delete_account_policy', [SettingController::class, 'deleteAccountPolicy'])->name('deleteAccountPolicy');


Route::group(['prefix' => 'auth', 'middleware' => 'guest:admin'], function () {
    Route::get('login', [AuthController::class, 'showLoginForm'])->name('login');
    Route::post('login', [AuthController::class, 'login'])->name('postLogin');
});

Route::group(['middleware' => 'auth:admin'], function () {
    Route::get('/', [DashboardController::class, 'index'])->name('index');

    Route::group(['prefix' => 'admins'], function () {
        Route::get('/', [AdminController::class, 'index'])->name('dashboard.admins.index');
        Route::get('/getIndex', [AdminController::class, 'getIndex'])->name('dashboard.admins.getIndex');
        Route::post('/store', [AdminController::class, 'store'])->name('dashboard.admins.store');
        Route::post('/update', [AdminController::class, 'update'])->name('dashboard.admins.update');
        Route::post('/delete', [AdminController::class, 'delete'])->name('dashboard.admins.delete');
    });
    Route::group(['prefix' => 'generals'], function () {
        Route::get('/getEducationalAreas', [GemeralController::class, 'getEducationalAreas'])->name('getEducationalAreas');
        Route::get('/getShcools', [GemeralController::class, 'getShcools'])->name('getShcools');
        Route::get('/getSection', [GemeralController::class, 'getSections'])->name('getSections');
    });

    //
    Route::group(['prefix' => 'roles'], function () {
        Route::get('/', [RoleController::class, 'index'])->name('dashboard.roles.index');
        Route::get('/getIndex', [RoleController::class, 'getIndex'])->name('dashboard.roles.getIndex');
        Route::post('/store', [RoleController::class, 'store'])->name('dashboard.roles.store');
        Route::post('/update', [RoleController::class, 'update'])->name('dashboard.roles.update');
        Route::post('/delete', [RoleController::class, 'delete'])->name('dashboard.roles.delete');
    });

    Route::group(['prefix' => 'my-profile'], function () {
        Route::get('/', [ProfileController::class, 'getProfile'])->name('dashboard.profile.getProfile');
        Route::post('/profile', [ProfileController::class, 'Profile'])->name('dashboard.profile.profile');
        Route::post('/change-password', [ProfileController::class, 'changePassword'])->name('dashboard.profile.changePassword');
    });


    Route::group(['prefix' => 'governorates'], function () {
        Route::get('/', [GovernorateController::class, 'index'])->name('dashboard.governorates.index');
        Route::get('/getIndex', [GovernorateController::class, 'getIndex'])->name('dashboard.governorates.getIndex');
        Route::post('/store', [GovernorateController::class, 'store'])->name('dashboard.governorates.store');
        Route::post('/update', [GovernorateController::class, 'update'])->name('dashboard.governorates.update');
        Route::post('/delete', [GovernorateController::class, 'delete'])->name('dashboard.governorates.delete');
    });


    Route::group(['prefix' => 'education-areaes'], function () {
        Route::get('/', [EducationAreaController::class, 'index'])->name('dashboard.educationAreaes.index');
        Route::get('/getIndex', [EducationAreaController::class, 'getIndex'])->name('dashboard.educationAreaes.getIndex');
        Route::post('/store', [EducationAreaController::class, 'store'])->name('dashboard.educationAreaes.store');
        Route::post('/update', [EducationAreaController::class, 'update'])->name('dashboard.educationAreaes.update');
        Route::post('/delete', [EducationAreaController::class, 'delete'])->name('dashboard.educationAreaes.delete');
        Route::post('/updateStatus', [EducationAreaController::class, 'updateStatus'])->name('dashboard.educationAreaes.updateStatus');
    });





    Route::group(['prefix' => 'schools'], function () {
        Route::get('/', [ShcoolController::class, 'index'])->name('dashboard.schools.index');
        Route::get('/getIndex', [ShcoolController::class, 'getIndex'])->name('dashboard.schools.getIndex');
        Route::post('/store', [ShcoolController::class, 'store'])->name('dashboard.schools.store');
        Route::post('/update', [ShcoolController::class, 'update'])->name('dashboard.schools.update');
        Route::post('/delete', [ShcoolController::class, 'delete'])->name('dashboard.schools.delete');

        Route::post('/upload', [ShcoolController::class, 'uploadExcel'])->name('dashboard.schools.uploadExcel');
    });

    Route::group(['prefix' => 'class-rooms'], function () {
        Route::get('/', [ClassRoomController::class, 'index'])->name('dashboard.classRooms.index');
        Route::get('/getIndex', [ClassRoomController::class, 'getIndex'])->name('dashboard.classRooms.getIndex');
        Route::post('/store', [ClassRoomController::class, 'store'])->name('dashboard.classRooms.store');
        Route::post('/update', [ClassRoomController::class, 'update'])->name('dashboard.classRooms.update');
        Route::post('/delete', [ClassRoomController::class, 'delete'])->name('dashboard.classRooms.delete');
    });

    Route::group(['prefix' => 'levels'], function () {
        Route::get('/', [LevelController::class, 'index'])->name('dashboard.levels.index');
        Route::get('/getIndex', [LevelController::class, 'getIndex'])->name('dashboard.levels.getIndex');
        Route::post('/store', [LevelController::class, 'store'])->name('dashboard.levels.store');
        Route::post('/update', [LevelController::class, 'update'])->name('dashboard.levels.update');
        Route::post('/delete', [LevelController::class, 'delete'])->name('dashboard.levels.delete');
    });


    Route::group(['prefix' => 'materials'], function () {
        Route::get('/', [MatirealsController::class, 'index'])->name('dashboard.materials.index');
        Route::get('/getIndex', [MatirealsController::class, 'getIndex'])->name('dashboard.materials.getIndex');
        Route::post('/store', [MatirealsController::class, 'store'])->name('dashboard.materials.store');
        Route::post('/update', [MatirealsController::class, 'update'])->name('dashboard.materials.update');
        Route::post('/delete', [MatirealsController::class, 'delete'])->name('dashboard.materials.delete');
        Route::post('/save-attachment', [MatirealsController::class, 'saveAttachment'])->name('dashboard.materials.addAttachment');
        Route::get('/getAttachments', [MatirealsController::class, 'getAttachments'])->name('dashboard.materials.getAttachments');
        Route::get('/getChapters', [MatirealsController::class, 'getChapters'])->name('dashboard.materials.getChapters');
        Route::post('/addchapter', [MatirealsController::class, 'addchapter'])->name('dashboard.materials.addchapter');
        Route::get('/getChaptersByMaterialId', [MatirealsController::class, 'getChaptersByMaterialId'])->name('dashboard.materials.getChaptersByMaterialId');
        Route::get('/ExamList', [MatirealsController::class, 'getExams'])->name('dashboard.materials.ExamList');
        Route::post('/addExam', [MatirealsController::class, 'addExam'])->name('dashboard.materials.addExam');
    });




    Route::group(['prefix' => 'students'], function () {
        Route::get('/', [App\Http\Controllers\Dashboard\Students\StudentController::class, 'index'])->name('dashboard.students.index');
        Route::get('/getIndex', [App\Http\Controllers\Dashboard\Students\StudentController::class, 'getIndex'])->name('dashboard.students.getIndex');
        Route::post('/store', [App\Http\Controllers\Dashboard\Students\StudentController::class, 'store'])->name('dashboard.students.store');
        Route::post('/update', [App\Http\Controllers\Dashboard\Students\StudentController::class, 'update'])->name('dashboard.students.update');
        Route::post('/delete', [App\Http\Controllers\Dashboard\Students\StudentController::class, 'delete'])->name('dashboard.students.delete');
        Route::post('/uploadExcel', [App\Http\Controllers\Dashboard\Students\StudentController::class, 'uploadExcel'])->name('dashboard.students.uploadExcel');
    });
    Route::group(['prefix' => 'labs'], function () {
        Route::get('/', [App\Http\Controllers\Dashboard\Labs\LabController::class, 'index'])->name('dashboard.labs.index');
        Route::get('/getIndex', [App\Http\Controllers\Dashboard\Labs\LabController::class, 'getIndex'])->name('dashboard.labs.getIndex');
        Route::post('/store', [App\Http\Controllers\Dashboard\Labs\LabController::class, 'store'])->name('dashboard.labs.store');
        Route::post('/update', [App\Http\Controllers\Dashboard\Labs\LabController::class, 'update'])->name('dashboard.labs.update');
        Route::post('/delete', [App\Http\Controllers\Dashboard\Labs\LabController::class, 'delete'])->name('dashboard.labs.delete');
    });

    Route::group(['prefix' => 'exams'], function () {
        Route::get('/', [App\Http\Controllers\Dashboard\Exams\ExamController::class, 'index'])->name('dashboard.exams.index');
        Route::get('/getIndex', [App\Http\Controllers\Dashboard\Exams\ExamController::class, 'getIndex'])->name('dashboard.exams.getIndex');
        Route::post('/store', [App\Http\Controllers\Dashboard\Exams\ExamController::class, 'store'])->name('dashboard.exams.store');
        Route::post('/update', [App\Http\Controllers\Dashboard\Exams\ExamController::class, 'update'])->name('dashboard.exams.update');
        Route::post('/delete', [App\Http\Controllers\Dashboard\Exams\ExamController::class, 'delete'])->name('dashboard.exams.delete');
        Route::get('/getChapters', [App\Http\Controllers\Dashboard\Exams\ExamController::class, 'getchapters'])->name('dashboard.exams.getchapters');
    });
    Route::group(['prefix' => 'class-sections'], function () {
        Route::get('/', [App\Http\Controllers\Dashboard\classSections\classSectionController::class, 'index'])->name('dashboard.classSections.index');
        Route::get('/getIndex', [App\Http\Controllers\Dashboard\classSections\classSectionController::class, 'getIndex'])->name('dashboard.classSections.getIndex');
        Route::post('/store', [App\Http\Controllers\Dashboard\classSections\classSectionController::class, 'store'])->name('dashboard.classSections.store');
        Route::post('/update', [App\Http\Controllers\Dashboard\classSections\classSectionController::class, 'update'])->name('dashboard.classSections.update');
        Route::post('/delete', [App\Http\Controllers\Dashboard\classSections\classSectionController::class, 'delete'])->name('dashboard.classSections.delete');
    });

    Route::group(['prefix' => 'settings'], function () {
        Route::get('/', [App\Http\Controllers\Dashboard\Settings\SettingController::class, 'index'])->name('dashboard.settings.index');
        Route::post('/update', [App\Http\Controllers\Dashboard\Settings\SettingController::class, 'update'])->name('dashboard.settings.update');
    });

    Route::group(['prefix' => 'contests'], function () {
        Route::get('/', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'index'])->name('dashboard.contests.index');
        Route::get('/getIndex', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'getIndex'])->name('dashboard.contests.getIndex');
        Route::post('/store', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'store'])->name('dashboard.contests.store');
        Route::post('/update', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'update'])->name('dashboard.contests.update');
        Route::post('/delete', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'delete'])->name('dashboard.contests.delete');
        Route::get('/questionList', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'questionList'])->name('dashboard.contests.questionList');
        Route::post('/save-attachment', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'saveAttachment'])->name('dashboard.contests.addAttachment');
        Route::get('/getAttachments', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'getAttachments'])->name('dashboard.contests.getAttachments');
        Route::post('/addquestion', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'addquestion'])->name('dashboard.contests.addquestion');
        Route::get('/getQuestions', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'getQuestions'])->name('dashboard.contests.getQuestions');
        Route::post('/uploadExcel', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'uploadExcel'])->name('dashboard.contests.uploadExcel');
        Route::post('/addPhoto', [App\Http\Controllers\Dashboard\Contests\ContestController::class, 'addPhoto'])->name('dashboard.contests.addPhoto');
        Route::group(['prefix' => 'contests-models'], function () {
            Route::get('/', [App\Http\Controllers\Dashboard\ContestsModels\ContestsController::class, 'index'])->name('dashboard.contestModels.index');
            Route::get('/getIndex', [App\Http\Controllers\Dashboard\ContestsModels\ContestsController::class, 'getIndex'])->name('dashboard.contestModels.getIndex');
            Route::post('/store', [App\Http\Controllers\Dashboard\ContestsModels\ContestsController::class, 'store'])->name('dashboard.contestModels.store');
            Route::post('/update', [App\Http\Controllers\Dashboard\ContestsModels\ContestsController::class, 'update'])->name('dashboard.contestModels.update');
            Route::post('/delete', [App\Http\Controllers\Dashboard\ContestsModels\ContestsController::class, 'delete'])->name('dashboard.contestModels.delete');
        });
        Route::group(['prefix' => 'contests-questions'], function () {
            Route::get('/', [App\Http\Controllers\Dashboard\Contests\ContestQuestionsController::class, 'index'])->name('dashboard.contestQuestions.index');
            Route::get('/getIndex', [App\Http\Controllers\Dashboard\Contests\ContestQuestionsController::class, 'getIndex'])->name('dashboard.contestQuestions.getIndex');
            Route::post('/store', [App\Http\Controllers\Dashboard\Contests\ContestQuestionsController::class, 'store'])->name('dashboard.contestQuestions.store');
            Route::post('/update', [App\Http\Controllers\Dashboard\Contests\ContestQuestionsController::class, 'update'])->name('dashboard.contestQuestions.update');
            Route::post('/delete', [App\Http\Controllers\Dashboard\Contests\ContestQuestionsController::class, 'delete'])->name('dashboard.contestQuestions.delete');
            Route::post('/uploadExcel', [App\Http\Controllers\Dashboard\Contests\ContestQuestionsController::class, 'uploadExcel'])->name('dashboard.contestQuestions.uploadExcel');
        });
    });

    Route::group(['prefix' => 'notifications'], function () {
        Route::get('/', [NotificationController::class, 'create'])->name('dashboard.notifications.create');
        Route::post('/post-notification', [NotificationController::class, 'store'])->name('dashboard.notifications.store');
    });



    Route::group(['prefix' => 'achievements'], function () {
        Route::get('/', [App\Http\Controllers\Dashboard\Achievements\AchievementController::class, 'index'])->name('dashboard.achievements.index');
        Route::get('/getIndex', [App\Http\Controllers\Dashboard\Achievements\AchievementController::class, 'getIndex'])->name('dashboard.achievements.getIndex');
        Route::post('/excel', [App\Http\Controllers\Dashboard\Achievements\AchievementController::class, 'exportToExcel'])->name('dashboard.achievements.excel');
        Route::post('/delete', [App\Http\Controllers\Dashboard\Achievements\AchievementController::class, 'delete'])->name('dashboard.achievements.delete');

    });
});
